package org.openqa.selenium.devtools.v118.eventbreakpoints;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * EventBreakpoints permits setting breakpoints on particular operations and
 * events in targets that run JavaScript but do not have a DOM.
 * JavaScript execution will stop on these operations as if there was a regular
 * breakpoint set.
 */
@Beta()
public class EventBreakpoints {

    /**
     * Sets breakpoint on particular native event.
     */
    public static Command<Void> setInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.setInstrumentationBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes breakpoint on particular native event.
     */
    public static Command<Void> removeInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.removeInstrumentationBreakpoint", Map.copyOf(params));
    }
}
