package org.openqa.selenium.devtools.v120.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Send a list of any errors that need to be delivered.
 */
public class PlayerErrorsRaised {

    private final org.openqa.selenium.devtools.v120.media.model.PlayerId playerId;

    private final java.util.List<org.openqa.selenium.devtools.v120.media.model.PlayerError> errors;

    public PlayerErrorsRaised(org.openqa.selenium.devtools.v120.media.model.PlayerId playerId, java.util.List<org.openqa.selenium.devtools.v120.media.model.PlayerError> errors) {
        this.playerId = java.util.Objects.requireNonNull(playerId, "playerId is required");
        this.errors = java.util.Objects.requireNonNull(errors, "errors is required");
    }

    public org.openqa.selenium.devtools.v120.media.model.PlayerId getPlayerId() {
        return playerId;
    }

    public java.util.List<org.openqa.selenium.devtools.v120.media.model.PlayerError> getErrors() {
        return errors;
    }

    private static PlayerErrorsRaised fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v120.media.model.PlayerId playerId = null;
        java.util.List<org.openqa.selenium.devtools.v120.media.model.PlayerError> errors = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "playerId":
                    playerId = input.read(org.openqa.selenium.devtools.v120.media.model.PlayerId.class);
                    break;
                case "errors":
                    errors = input.readArray(org.openqa.selenium.devtools.v120.media.model.PlayerError.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerErrorsRaised(playerId, errors);
    }
}
